#include <algorithm>
#include <cstdint>
#include <cstring>
#include <iostream>
#include <stack>
#include <tuple>
#include <unordered_map>
#include <vector>

using namespace std;

typedef unordered_map<uint16_t, unordered_map<uint16_t, int16_t>> Graph;
constexpr int16_t INF = 30000;
constexpr int16_t NEG_INF = -30000;
constexpr int16_t unvisited = -1;

uint32_t solve(const vector<uint32_t> &arr);
uint32_t ldslen(const vector<uint32_t> &arr);

[[gnu::hot]]
uint32_t solve(const vector<uint32_t> &arr) {
  vector<uint32_t> reversed(arr.rbegin(), arr.rend());
  return ldslen(reversed);
}

uint32_t ldslen(const vector<uint32_t> &arr) {
  vector<uint32_t> lds;
  for (uint32_t k : arr) {
    auto it = lower_bound(lds.begin(), lds.end(), k);
    if (it == lds.end())
      lds.emplace_back(k);
    else
      *it = k;
  }
  return lds.size();
}

int main() noexcept {
    return 0;
}